<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function markets()
	{
		return $this->belongsToMany('Market', 'market_id', 'user_id');
	}

	public function wallet()
	{
		return $this->hasOne('Wallet', 'user_id');
	}

	public function portfolio()
	{
		return $this->hasOne('Portfolio', 'user_id');
	}

}