<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 255)->nullable();
			$table->string('email', 255);
			$table->string('password', 255);
			$table->string('guid', 255);
			$table->enum('role', array('admin', 'client'));
			$table->boolean('status')->default(1);
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}