<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomerMetaTable extends Migration {

	public function up()
	{
		Schema::create('customer_meta', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('first_name', 255);
			$table->string('last_name', 255)->nullable();
			$table->string('phone', 255)->nullable();
			$table->datetime('date_last_active')->nullable();
			$table->string('country', 255)->nullable();
			$table->string('post_code', 255)->nullable();
			$table->string('city', 255)->nullable();
			$table->string('street', 255)->nullable();
			$table->string('street_number', 255)->nullable();
			$table->string('guid', 255)->nullable();
			$table->integer('id_user')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('customer_meta');
	}
}