<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('id_user')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('id_coupon')->references('id')->on('coupons')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->foreign('id_order')->references('id')->on('orders')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('coupons', function(Blueprint $table) {
			$table->foreign('id_order')->references('id')->on('orders')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->foreign('id_epice')->references('id')->on('epices')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->foreign('id_user')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('epices', function(Blueprint $table) {
			$table->foreign('id_category')->references('id')->on('category')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('epices', function(Blueprint $table) {
			$table->foreign('id_tax')->references('id')->on('taxs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('promotions', function(Blueprint $table) {
			$table->foreign('id_epice')->references('id')->on('epices')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product_meta', function(Blueprint $table) {
			$table->foreign('id_epice')->references('id')->on('epices')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->foreign('id_order')->references('id')->on('orders')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('customer_meta', function(Blueprint $table) {
			$table->foreign('id_user')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_id_user_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_id_coupon_foreign');
		});
		Schema::table('invoices', function(Blueprint $table) {
			$table->dropForeign('invoices_id_order_foreign');
		});
		Schema::table('coupons', function(Blueprint $table) {
			$table->dropForeign('coupons_id_order_foreign');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->dropForeign('reviews_id_epice_foreign');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->dropForeign('reviews_id_user_foreign');
		});
		Schema::table('epices', function(Blueprint $table) {
			$table->dropForeign('epices_id_category_foreign');
		});
		Schema::table('epices', function(Blueprint $table) {
			$table->dropForeign('epices_id_tax_foreign');
		});
		Schema::table('promotions', function(Blueprint $table) {
			$table->dropForeign('promotions_id_epice_foreign');
		});
		Schema::table('product_meta', function(Blueprint $table) {
			$table->dropForeign('product_meta_id_epice_foreign');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->dropForeign('order_items_id_order_foreign');
		});
		Schema::table('customer_meta', function(Blueprint $table) {
			$table->dropForeign('customer_meta_id_user_foreign');
		});
	}
}