<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Products extends Model 
{

    protected $table = 'products';
    public $timestamps = true;
    protected $fillable = array('product_code', 'product_name', 'product_title', 'product_subtitle', 'product_description', 'product_stock', 'cost', 'display_price', 'is_active', 'product_avg_rating');

    public function categories()
    {
        return $this->belongsTo('Categories');
    }

    public function productMaterial()
    {
        return $this->belongsTo('ProductMaterial');
    }

    public function brandModel()
    {
        return $this->belongsTo('BrandModel');
    }

    public function offers()
    {
        return $this->belongsTo('Offers');
    }

}