<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Brand extends Model 
{

    protected $table = 'brands';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function brandModels()
    {
        return $this->hasMany('BrandModel');
    }

    public function brand()
    {
        return $this->belongsTo('Brand');
    }

}