<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Brand extends Eloquent {

	protected $table = 'brands';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function brandModels()
	{
		return $this->hasMany('BrandModel');
	}

	public function brand()
	{
		return $this->belongsTo('Brand');
	}

}