<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class BrandModel extends Eloquent {

	protected $table = 'brand_models';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function brand()
	{
		return $this->belongsTo('Brand');
	}

	public function products()
	{
		return $this->hasMany('Products');
	}

	public function offers()
	{
		return $this->belongsTo('Offers');
	}

}