<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientsTable extends Migration {

	public function up()
	{
		Schema::create('clients', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->string('password');
			$table->string('phone');
			$table->date('d_o_b');
			$table->string('email');
			$table->date('last_donation_date');
			$table->string('pin_code');
			$table->integer('blood_type_id')->unsigned();
			$table->integer('city_id')->unsigned();
			$table->boolean('is-active')->default(1);
			$table->string('api_token', 60)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('clients');
	}
}