<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRuptlProposalTable extends Migration {

	public function up()
	{
		Schema::create('ruptl_proposal', function(Blueprint $table) {
			$table->uuid('id_proposal_ruptl')->primary();
			$table->integer('id_jenis_usulan')->unsigned();
			$table->integer('id_provinsi')->unsigned();
			$table->uuid('id_dokumen');
			$table->string('nama', 50);
			$table->integer('jumlah')->unsigned()->nullable();
			$table->string('satuan', 50)->nullable();
			$table->datetime('tanggal')->nullable();
			$table->text('keterangan')->nullable();
			$table->timestamps();
			$table->integer('created_by');
			$table->integer('updated_by');
		});
	}

	public function down()
	{
		Schema::drop('ruptl_proposal');
	}
}