<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('first_name', 191);
			$table->string('last_name', 191);
			$table->string('middle_name', 191);
			$table->date('birthdate');
			$table->string('email', 191);
			$table->string('password', 191);
			$table->string('phone', 191);
			$table->string('image', 191);
			$table->enum('gender', array('male', 'female'));
			$table->boolean('is_rider');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}