<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSupplierOrdersTable extends Migration {

	public function up()
	{
		Schema::create('supplier_orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('num')->unique();
			$table->bigInteger('supplier_id')->unsigned();
			$table->double('total');
			$table->tinyInteger('status')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('supplier_orders');
	}
}