<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReviewOrdersTable extends Migration {

	public function up()
	{
		Schema::create('review_orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('order_id')->unsigned();
			$table->integer('rate')->default('0');
			$table->text('comment');
			$table->tinyInteger('status')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('review_orders');
	}
}