<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReturnOrdersTable extends Migration {

	public function up()
	{
		Schema::create('return_orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('order_id')->unsigned();
			$table->bigInteger('product_id')->unsigned();
			$table->string('reason');
			$table->tinyInteger('status')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('return_orders');
	}
}