<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateShippingsTable extends Migration {

	public function up()
	{
		Schema::create('shippings', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->bigInteger('country_id')->unsigned();
			$table->bigInteger('governate_id')->unsigned();
			$table->bigInteger('region_id')->unsigned();
			$table->double('price');
			$table->tinyInteger('type')->default('0');
			$table->string('time_of_delivery');
		});
	}

	public function down()
	{
		Schema::drop('shippings');
	}
}