<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInstitutesTable extends Migration {

	public function up()
	{
		Schema::create('institutes', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('location_id')->unsigned();
			$table->bigInteger('religious_grouping_id')->unsigned();
			$table->string('name');
			$table->string('address')->nullable();
			$table->string('tel_no')->nullable();
			$table->string('fax_no')->nullable();
			$table->string('email')->nullable();
			$table->string('website');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('institutes');
	}
}