<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSetsTable extends Migration {

	public function up()
	{
		Schema::create('sets', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name')->nullable();
			$table->integer('created_by')->unsigned()->nullable();
			$table->timestamps();
			$table->integer('updated_by')->unsigned()->nullable();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('sets');
	}
}