<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Institution extends Eloquent {

	protected $table = 'institutions';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $guarded = array('namespace');

	public function getGroups()
	{
		return $this->hasMany('App\Group');
	}

	public function getSubscription()
	{
		return $this->hasOne('App\Subscription');
	}

}