<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Institution extends Model 
{

    protected $table = 'institutions';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $guarded = array('namespace');

    public function getGroups()
    {
        return $this->hasMany('App\Group');
    }

    public function getSubscription()
    {
        return $this->hasOne('App\Subscription');
    }

}