<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Item extends Model 
{

    protected $table = 'items';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function media()
    {
        return $this->morphToMany('Media', 'mediaable');
    }

    public function extraItems()
    {
        return $this->belongsToMany('Item', 'extra_items');
    }

}