<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAddressesTable extends Migration {

	public function up()
	{
		Schema::create('addresses', function(Blueprint $table) {
			$table->increments('id');
			$table->text('street')->nullable();
			$table->string('city')->nullable();
			$table->string('state')->nullable();
			$table->float('lat', 10,6)->nullable();
			$table->float('lng', 10,6)->nullable();
			$table->tinyInteger('is_main')->nullable()->default('0');
			$table->string('land_line')->nullable();
			$table->text('details')->nullable();
			$table->bigInteger('customer_id')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('addresses');
	}
}