<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBranchItemsCustomizeTable extends Migration {

	public function up()
	{
		Schema::create('branch_items_customize', function(Blueprint $table) {
			$table->increments('id');
			$table->nullableMorphs('customize');
			$table->decimal('price', 10,2)->nullable()->default('0');
			$table->boolean('is_available')->nullable()->default(0);
			$table->bigInteger('branch_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('branch_items_customize');
	}
}