<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAreasTable extends Migration {

	public function up()
	{
		Schema::create('areas', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name')->nullable();
			$table->bigInteger('zone_id')->nullable();
			$table->bigInteger('branch_id')->nullable();
			$table->float('lat', 10,6)->default('0');
			$table->float('lng', 10,6)->default('0');
			$table->tinyInteger('is_active')->default('0');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('areas');
	}
}