<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateItemsTable extends Migration {

	public function up()
	{
		Schema::create('items', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name')->nullable();
			$table->decimal('price', 10,2)->default('0');
			$table->string('image')->nullable();
			$table->text('description')->nullable();
			$table->tinyInteger('is_active')->default('0');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('items');
	}
}