<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Branch extends Eloquent {

	protected $table = 'branches';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function itemsUnavailable()
	{
		return $this->hasManyThrough('Item', 'branchItemUnavailable');
	}

	public function itemsAvailable()
	{
		return $this->hasManyThrough('Item', 'branchItemUnavailable');
	}

}