<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Item extends Eloquent {

	protected $table = 'items';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function media()
	{
		return $this->morphToMany('Media', 'mediaable');
	}

	public function extraItems()
	{
		return $this->belongsToMany('Item', 'extra_items');
	}

}