<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateItemSizesTable extends Migration {

	public function up()
	{
		Schema::create('item_sizes', function(Blueprint $table) {
			$table->increments('id');
			$table->string('size')->nullable();
			$table->decimal('price', 10,2)->nullable()->default('0');
			$table->bigInteger('item_id')->nullable();
			$table->bigInteger('branch_id')->nullable();
			$table->boolean('is_available')->nullable()->default(0);
		});
	}

	public function down()
	{
		Schema::drop('item_sizes');
	}
}