<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderItemsTable extends Migration {

	public function up()
	{
		Schema::create('order_items', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('order_id');
			$table->bigInteger('item_id');
			$table->smallInteger('quantity')->default('0');
			$table->decimal('price', 10,2)->default('0');
			$table->decimal('subtotal', 10,2)->default('0');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('order_items');
	}
}