<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientsTable extends Migration {

	public function up()
	{
		Schema::create('clients', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('support_code');
			$table->string('name');
			$table->string('organization');
			$table->integer('country_id');
			$table->text('address');
			$table->string('telephone');
			$table->integer('activity_id');
			$table->string('know_us_from');
			$table->string('email');
			$table->string('password');
			$table->rememberToken('rememberToken');
		});
	}

	public function down()
	{
		Schema::drop('clients');
	}
}