<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Articulo extends Model 
{

    protected $table = 'articulo';
    public $timestamps = true;

    public function trabajador()
    {
        return $this->belongsTo('App\Trabajador', 'trabajador_id');
    }

    public function ropa()
    {
        return $this->belongsTo('App\Ropa', 'ropa_id');
    }

    public function lote()
    {
        return $this->belongsToMany('App\Lote', 'lote_id')->using('App\ArticuloLote');
    }

    public function estado()
    {
        return $this->belongsTo('App\EstadoArticulo', 'estado_id');
    }

}