<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Trabajador extends Model 
{

    protected $table = 'trabajador';
    public $timestamps = true;

    public function planta()
    {
        return $this->belongsTo('App\Planta', 'planta_id');
    }

    public function articulo()
    {
        return $this->hasMany('App\Articulo', 'trabajador_id');
    }

    public function area()
    {
        return $this->belongsTo('App\Area', 'area_id');
    }

}