<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateListingsTable extends Migration {

	public function up()
	{
		Schema::create('listings', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id');
			$table->bigInteger('category_id');
			$table->enum('type', array(''for_sale'', ''for_rent''));
			$table->enum('status', array(''));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('listings');
	}
}