<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('categories', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 225);
			$table->bigInteger('parent_id')->index();
			$table->string('icon', 225)->default('default.png');
			$table->boolean('status')->default(true);
			$table->bigInteger('order')->nullable();
			$table->boolean('show_in_home');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('categories');
	}
}