<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientsTable extends Migration {

	public function up()
	{
		Schema::create('clients', function(Blueprint $table) {
			$table->increments('id');
			$table->string('email', 255)->unique();
			$table->string('phone', 255)->unique();
			$table->string('password', 255);
			$table->string('name', 255);
			$table->bigInteger('area_id')->unsigned();
			$table->boolean('is_active');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('clients');
	}
}