<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRestaurantsTable extends Migration {

	public function up()
	{
		Schema::create('restaurants', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->string('email')->unique();
			$table->string('phone');
			$table->string('password');
			$table->string('logo', 255);
			$table->bigInteger('area_id')->unsigned();
			$table->decimal('min_order', 10,2);
			$table->decimal('delivery_fee', 10,2);
			$table->string('status', 255);
			$table->integer('avg_rate');
			$table->string('contact_phone');
			$table->string('whatsapp_number');
			$table->boolean('is_active')->default(0);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('restaurants');
	}
}