<?php

namespace App\Models;

class Order extends Eloquent {

	protected $table = 'orders';
	public $timestamps = true;
	protected $fillable = array('address', 'payment_method_id', 'status', 'notes', 'commission', 'delivery_fee', 'total_amount', 'client_id', 'restaurant_id');

	public function meals()
	{
		return $this->belongsToMany('App\Models\Meal');
	}

	public function client()
	{
		return $this->belongsTo('App\Models\Client');
	}

	public function restaurant()
	{
		return $this->belongsTo('App\Models\Restaurant');
	}

	public function paymentMethod()
	{
		return $this->belongsTo('App\Models\PaymentMethod');
	}

}