<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReviewsTable extends Migration {

	public function up()
	{
		Schema::create('reviews', function(Blueprint $table) {
			$table->increments('id');
			$table->string('comment', 255);
			$table->string('review');
			$table->integer('rate');
			$table->bigInteger('client_id')->unsigned();
			$table->bigInteger('restaurant_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('reviews');
	}
}