<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class ProductUnit extends Model 
{

    protected $table = 'product_units';
    public $timestamps = true;

    public function product()
    {
        return $this->belongsTo('App\Product', 'product_id');
    }

    public function contains()
    {
        return $this->belongsTo('App\ProductUnit', 'contains_unit_id');
    }

    public function unit_type()
    {
        return $this->belongsTo('App\ProductUnitType', 'unit_type_id');
    }

    public function vendors()
    {
        return $this->belongsToMany('App\Vendor', 'vendor_product', 'vendor_id', 'product_unit_id')->withPivot('name','model','cost','created_at','updated_at');
    }

    public function barcodes()
    {
        return $this->hasMany('App\ProductUnitBarcode', 'product_unit_id');
    }

}