<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->boolean('credit_memo')->default(0);
			$table->date('date_purchased');
			$table->integer('customer_id')->unsigned();
			$table->string('company');
			$table->string('contact');
			$table->string('address');
			$table->string('city');
			$table->string('state');
			$table->string('zipcode');
			$table->string('phone');
			$table->string('email');
			$table->string('pay_method');
			$table->enum('status', array('Pending', 'Delivered'));
			$table->decimal('sub_total', 10,2);
			$table->decimal('discount', 10,2);
			$table->decimal('returns', 10,2);
			$table->decimal('delivery', 10,2);
			$table->decimal('total', 10,2);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}