<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdjustmentsTable extends Migration {

	public function up()
	{
		Schema::create('adjustments', function(Blueprint $table) {
			$table->increments('id');
			$table->date('date_adjusted');
			$table->integer('product_id')->unsigned();
			$table->string('name');
			$table->integer('quantity_adj');
			$table->integer('quantity_unit_id')->unsigned();
			$table->enum('reason', array('foo', 'bar'));
			$table->decimal('cost', 16,8);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('adjustments');
	}
}