<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Trip extends Model 
{

    protected $table = 'trips';
    public $timestamps = true;
    protected $fillable = array('user_id', 'vehicle_id', 'start_at', 'end_at', 'price', 'seats');

    public function user()
    {
        return $this->belongsTo('User');
    }

    public function vehicle()
    {
        return $this->hasOne('Vehicle');
    }

    public function routes()
    {
        return $this->hasMany('Route');
    }

    public function bookings()
    {
        return $this->hasMany('Booking');
    }

}