<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTbMailTable extends Migration {

	public function up()
	{
		Schema::create('tb_mail', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->integer('weight')->unsigned();
			$table->integer('count')->unsigned();
			$table->integer('id_airway')->unsigned();
			$table->integer('id_payment');
			$table->integer('id_room')->unsigned();
			$table->timestamps();
			$table->string('origin');
			$table->string('destination');
			$table->string('desc');
			$table->integer('price');
			$table->enum('status', array('true', 'false'));
		});
	}

	public function down()
	{
		Schema::drop('tb_mail');
	}
}