<?php

namespace App;

class AudioResource extends Eloquent {

	protected $table = 'audio_resources';
	public $timestamps = true;

	public function preActivities()
	{
		return $this->morphMany('App\PreSessionActivity', 'resource');
	}

	public function postActivities()
	{
		return $this->morphMany('App\PostSessionActivity', 'resource');
	}

	public function newPreActivities()
	{
		return $this->morphMany('App\SessionActivities', 'resource')->where('type', 'pre')->get();
	}

	public function newPostActivities()
	{
		return $this->morphMany('App\SessionActivities', 'resource')->where('type', 'post')->get();
	}

}