<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCouponsTable extends Migration {

	public function up()
	{
		Schema::create('coupons', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('code', 191);
			$table->string('offer_name', 191)->nullable();
			$table->text('offer_details')->nullable();
			$table->timestamp('end_at')->nullable();
			$table->boolean('add_to_offers');
			$table->enum('type', array('percentage', 'amount'));
			$table->enum('discount_type', array('product', 'category', 'total_price', 'get_free_product', 'gifts', 'product_collection'));
			$table->boolean('free_shipping');
			$table->integer('get_free_product_count')->default('0');
			$table->integer('usage_count')->default('0');
			$table->timestamp('expire_date')->nullable();
			$table->integer('count_usage_for_person')->default('0');
			$table->float('minimum_order')->nullable();
			$table->bigInteger('country_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('coupons');
	}
}