<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'country_code', 'phone', 'image', 'gender', 'email', 'active', 'block', 'facebook_token', 'google_token', 'country_id', 'code', 'points');

    public function country()
    {
        return $this->belongsTo('Models\Country');
    }

    public function addresses()
    {
        return $this->hasMany('Models\Address');
    }

    public function productReviews()
    {
        return $this->hasMany('Models\ProductReview');
    }

    public function wishlist()
    {
        return $this->hasMany('Models\Wishlist');
    }

    public function orders()
    {
        return $this->hasMany('Models\Order');
    }

    public function carts()
    {
        return $this->hasMany('Models\Cart');
    }

}