<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 191);
			$table->string('country_code', 191);
			$table->string('phone', 191)->unique()->nullable();
			$table->string('image', 191)->nullable();
			$table->enum('gender', array('male', 'female'))->nullable();
			$table->string('email', 191)->unique()->nullable();
			$table->boolean('active')->default(0);
			$table->boolean('block')->default(0);
			$table->text('facebook_token')->nullable();
			$table->text('google_token')->nullable();
			$table->bigInteger('country_id')->unsigned();
			$table->string('code', 191)->nullable();
			$table->string('password', 255)->nullable();
			$table->bigInteger('points')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}