<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SubCategory extends Model 
{

    protected $table = 'sub_categories';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'meta_details', 'category_id');

    public function category()
    {
        return $this->belongsTo('Models\Category');
    }

    public function products()
    {
        return $this->belongsToMany('Models\Product');
    }

}