<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 191)->nullable();
			$table->string('first_name', 50)->nullable();
			$table->string('last_name', 50)->nullable();
			$table->string('identification')->nullable();
			$table->string('phone', 191)->unique()->nullable();
			$table->string('email', 50)->unique()->nullable();
			$table->string('password', 255)->nullable();
			$table->double('balance', 15,2)->default('0');
			$table->boolean('notify')->default(true);
			$table->boolean('online')->default(false);
			$table->string('lang', 4)->default('ar');
			$table->string('status')->default('pending');
			$table->double('lat')->nullable();
			$table->double('lng')->nullable();
			$table->string('address', 255)->nullable();
			$table->string('gender', 20);
			$table->date('birthdate');
			$table->string('social_status', 30);
			$table->integer('vacation_count_current_year')->nullable();
			$table->integer('sick_vacation_count_current_year')->nullable();
			$table->integer('non_paid_vacation_current_year')->nullable();
			$table->double('salary');
			$table->string('currency')->default('SAR');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}