<?php

namespace \App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Product extends Eloquent {

	protected $table = 'product';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function category()
	{
		return $this->hasOne('\App\Models\Product\Category');
	}

	public function advertiser()
	{
		return $this->hasOne('\App\Models\Advertiser');
	}

	public function package()
	{
		return $this->belongsToMany('App\Models\Product\Package2', 'product_package_package');
	}

}