<?php

namespace App\Models\Customer;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Service extends Eloquent {

	protected $table = 'customer_service';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function contact()
	{
		return $this->hasMany('\App\Models\Customer\Contact');
	}

	public function filiale()
	{
		return $this->belongsTo('App\Models\Customer\Filiale');
	}

}